//********************************************************************
//  TrafficLightPanel.java       Author: Lewis/Loftus
//
//  Solution to Programming Project 4.15 (5E, p. 205)
//********************************************************************

import javax.swing.*;
import java.awt.*;

public class TrafficLightPanel extends JPanel
{
   private int currentState = 0;
   private final int NUM_LIGHTS = 3;
   private final int X = 50, Y = 10, WIDTH = 50, HEIGHT = 130;
   private final int DIAMETER = 30;
   private final int X_OFFSET = 10, Y_OFFSET = 10;
   private final int PANEL_WIDTH = 150, PANEL_HEIGHT = 230;
   //-----------------------------------------------------------------
   //  Creates the traffic light panel
   //-----------------------------------------------------------------
   public void TrafficLightPanel()
   {
      setPreferredSize(new Dimension(PANEL_WIDTH, PANEL_HEIGHT));
   }

   public Dimension getPreferredSize()
   {
      return new Dimension(PANEL_WIDTH, PANEL_HEIGHT);
   }

   public void paintComponent(Graphics page)
   {
      super.paintComponent(page);

      int lightOn = currentState % NUM_LIGHTS;

      setBackground(Color.white);

      page.setColor(Color.lightGray);
      page.fillRect(X, Y, WIDTH, HEIGHT);

      if (lightOn == 0)
         page.setColor(Color.red);
      else
         page.setColor(Color.darkGray);

      page.fillOval(X+X_OFFSET, Y+Y_OFFSET, DIAMETER, DIAMETER);

      if (lightOn == 1)
         page.setColor(Color.yellow);
      else
         page.setColor(Color.darkGray);
      page.fillOval(X+X_OFFSET, Y+DIAMETER+2*Y_OFFSET, DIAMETER, DIAMETER);

      if (lightOn == 2)
         page.setColor(Color.green);
      else
         page.setColor(Color.darkGray);
      page.fillOval(X+X_OFFSET, Y+2*DIAMETER+3*Y_OFFSET, DIAMETER, DIAMETER);

   }

   public void change()
   {
      currentState++;
      repaint();
   }
}